<?php
$this->load->view("top_application");
$values_posted_back = (is_array($this->input->post())) ? TRUE : FALSE;
$is_same = $values_posted_back === TRUE ? $this->input->post('is_same') : '';
$titleArray = $this->config->item('titleArray');
$discount_amount = $this->session->userdata('discount_amount');
?>

<section class="checkout_page">
  <div class="container">
    <div class="row">
      <div class="col-lg-9 col-md-9 col-sm-8  col-xs-12">
        <div class="cart_left">
          <h1>Delivery Info</h1>
          <div class="panel-group checkout-steps" id="accordion">
            <!-- checkout-step-1  -->
            <section class="panel panel-default checkout-step-01">
              <h4 class="checkout_title">
                <a data-toggle="collapse" data-parent="#accordion" href="javascript:void(0);"><span>1</span>User Logged In <span class="pull-right"><i class="fa fa-check-square"></i></span></a>
              </h4>
            </section>


            <!-- checkout-step-02  -->
            <section class="panel panel-default checkout-step-02">
              <h4 class="checkout_title"><a data-toggle="collapse" class="collapsed"><span>2</span>Delivery Address</a></h4>
              <div id="collapseTwo" class="panel-collapse collapse in">
                <div class="panel-body">
                  <div class="edit_address">
                    <?php
                    echo form_open('cart/delivery_info', '');
                    echo error_message();
                    echo validation_message();
                    ?>
                    <div class="row">
                      <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                        <h5>Shipping Address</h5>
                      </div>
                      <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                        <div class="pull-right"> 
                          <h5>Billing Address</h5> <input id="check_add" name="check_add" value="Y" onClick="Check_Bill_Ship(this.form);" type="checkbox" />
                          <label for="check_add">Same as Shipping address</label>
                        </div>
                      </div>
                    </div>
                    <div class="row">
                      <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                        <div class="form-group">
                          <select name="mtitle" class="form-control">
                            <option value="">Select Title</option>
                            <?php
                            foreach ($titleArray as $tk => $tval) {
                              $sel = ($mres['mtitle'] == $tk) ? 'selected' : '';
                              ?>
                              <option value="<?php echo $tk; ?>" <?php echo $sel; ?>><?php echo $tval; ?></option>
                              <?php
                            }
                            ?>
                          </select>
                        </div>
                        <div class="form-group">
                          <input type="text" name="ship_name" placeholder="Full Name*"  value="<?php echo $mres['name']; ?>" class="form-control" required />
                        </div>
                        <div class="form-group">
                          <input type="tel" pattern="[1-9]{1}[0-9]{9}" maxlength="10" name="ship_mobile" placeholder="Mobile Number*" value="<?php echo $mres['mobile']; ?>" class="form-control" required />
                        </div>
                        <div class="form-group">
                          <textarea name="ship_address" cols="1"  placeholder="Address Details*" rows="3"  class="form-control unicase-form-control" required><?php echo $mres['address']; ?></textarea>
                        </div>
                        <div class="form-group">
                          <input type="text" name="ship_lmark" value="<?php echo $mres['landmark']; ?>" placeholder="Landmark" class="form-control" />
                        </div>
                        <div class="form-group">
                          <input type="text" name="ship_city" value="<?php echo $mres['city']; ?>" placeholder="City*" class="form-control" required/>
                        </div>
                        <div class="form-group">
                          <input type="text" name="ship_pin" value="<?php echo $mres['zipcode']; ?>" placeholder="Pincode*" class="form-control" required />
                        </div>
                        <div class="form-group">
                          <input type="text" name="ship_state" placeholder="State*" value="<?php echo $mres['state']; ?>" class="form-control" required />
                        </div>
                        <div class="form-group">
                          <?php echo CountrySelectBox(array("name" => "ship_country", 'current_selected_val' => $mres['country'], "format" => 'class="form-control unicase-form-control text-input" required')); ?>
                        </div>
                      </div>
                      <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                        <div class="form-group">
                          <select name="bmtitle" class="form-control">
                            <option value="">Select Title</option>
                            <?php
                            foreach ($titleArray as $tk => $tval) {
                              $sel1 = ($mres['mtitle'] == $tk) ? 'selected' : '';
                              ?>
                              <option value="<?php echo $tk; ?>" <?php echo $sel1; ?>><?php echo $tval; ?></option>
                              <?php
                            }
                            ?>
                          </select>
                        </div>
                        <div class="form-group">
                          <input type="text" name="bil_name" placeholder="Full Name*"  value="<?php echo $mres['bil_name']; ?>" class="form-control" required />
                        </div>
                        <div class="form-group">
                          <input type="tel" pattern="[1-9]{1}[0-9]{9}" maxlength="10" name="bil_mobile" value="<?php echo $mres['bil_mobile']; ?>" placeholder="Mobile Number*" class="form-control" required />
                        </div>
                        <div class="form-group">
                          <textarea name="bil_address" cols="1" placeholder="Address Details*" rows="3" class="form-control unicase-form-control" required><?php echo $mres['bil_address']; ?></textarea>
                        </div>
                        <div class="form-group">
                          <input type="text" name="bil_lmark" value="<?php echo $mres['bil_landmark']; ?>" placeholder="Landmark" class="form-control"/>
                        </div>
                        <div class="form-group">
                          <input type="text" name="bil_city" value="<?php echo $mres['bil_city']; ?>" placeholder="City*" class="form-control" required />
                        </div>
                        <div class="form-group">
                          <input type="text" name="bil_pin" value="<?php echo $mres['bil_zipcode']; ?>" placeholder="Pincode*" class="form-control" required />
                        </div>
                        <div class="form-group">
                          <input type="text" name="bil_state" value="<?php echo $mres['bil_state']; ?>" placeholder="State*" class="form-control" required />
                        </div>
                        <div class="form-group">
                          <?php echo CountrySelectBox(array("name" => "bil_country", 'current_selected_val' => $mres['bil_country'], "format" => 'class="form-control unicase-form-control text-input" required')); ?>
                        </div>
                        <div class="form-group">
                          <textarea name="last_shopping_comment" cols="1" placeholder="Comments" rows="3" class="form-control unicase-form-control"><?php echo $mres['last_shopping_comment']; ?></textarea>
                        </div>
                      </div>
                      <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6">
                      </div>
                      <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6">
                        <div class="form-group">
                          <button tabindex="9" class="modal_btn save_btn pull-right" type="submit" name="submit" >Checkout</button>
                        </div>
                      </div>
                    </div>
                    <?php echo form_close(); ?>
                  </div>
                </div>
              </div>
            </section>
            <!-- checkout-step-03  -->
            <div class="panel panel-default checkout-step-03">
              <h4 class="checkout_title"><a data-toggle="collapse" class="collapsed"><span>3</span>Order Summary <button class="change">View Order Summary</button></a></h4>
            </div>

            <!-- checkout-step-04  -->
            <div class="panel panel-default checkout-step-04">
              <h4 class="checkout_title"><a data-toggle="collapse" class="collapsed"><span>4</span>Payment Options</a></h4>
            </div>
            <!-- checkout-step-04  -->

          </div>
          <!-- /.checkout-steps -->
        </div>
      </div>
      <div class="col-lg-3 col-md-3 col-sm-4  col-xs-12">
        <div class="left_title">Cart Details</div>
        <div class="cart_right">
          <?php
          $cart = $this->cart->contents();
          $totalAmount = $origAmount = $discountAmt = 0;
          $i = 1;
          foreach ($cart as $items) {
            //trace($items);
            $shipping = 0;
            $totalAmount += $items['price'] * $items['qty'];
            $price = $items['price'];
          }
          ?>
          <table class="table table-totals">
            <tbody>
              <tr>
                <td>Price (items)</td>
                <td>&#8377 <?php echo $totalAmount; ?></td>
              </tr>
              <?php
              if ($discount_amount > 0) {
                ?>
                <tr>
                  <td>Coupon discount</td>
                  <td>&#8377 <?= $discount_amount; ?></td>
                </tr>
                <tr>
                  <td>Total</td>
                  <td>&#8377 <?php echo ($totalAmount - $discount_amount); ?></td>
                </tr>
              </tbody>
              <?php
            } else {
              ?>
              <tr>
                <td>Delivery charges</td>
                <td class="free">Free</td>
              </tr>
              <tfoot>
                <tr>
                  <td>Total Amount</td>
                  <td>&#8377 <?php echo $totalAmount; ?></td>
                </tr>
              </tfoot>
              <?php
            }
            ?>
          </table>
          <p class="safe_info"><i class="fa fa-shield"></i> Safe and Secure Payments. Easy returns. 100% Authentic products.</p>
        </div>
      </div>

    </div>
  </div>    
</section>
<script type="text/javascript">
  function Check_Bill_Ship(chk) {
    if (chk.check_add.checked == 1) {
      chk.bmtitle.value = chk.mtitle.value;
      chk.bil_name.value = chk.ship_name.value;
      chk.bil_mobile.value = chk.ship_mobile.value;
      chk.bil_address.value = chk.ship_address.value;
      chk.bil_lmark.value = chk.ship_lmark.value;
      chk.bil_city.value = chk.ship_city.value;
      chk.bil_pin.value = chk.ship_pin.value;
      chk.bil_state.value = chk.ship_state.value;
      chk.bil_country.value = chk.ship_country.options[chk.ship_country.selectedIndex].value;
    }
    if (chk.check_add.checked == 0) {
      chk.bmtitle.value = '';
      chk.bil_name.value = '';
      chk.bil_mobile.value = '';
      chk.bil_address.value = '';
      chk.bil_lmark.value = '';
      chk.bil_city.value = '';
      chk.bil_pin.value = '';
      chk.bil_state.value = '';
      chk.bil_country.value = chk.ship_country.options[0].value;
    }
  }
</script>
<?php $this->load->view("bottom_application"); ?>